<?php
    /**
    *
    * copyright (c) 2013-2020 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    * 	Classe che gestisce la presenza della popup in una determinata categoria,
    *   o della home
    */

    class GeneratoreDatiStrutturati {
        
        static function esegui($contenuto,$impostazioniAspetto,$configurazioneAspetto) {
            // se si tratta della home page il link del sito è semplicemetne la url, altrimenti viene generato
            $link = ($contenuto["id"] == $impostazioniAspetto["homePage"]) ? GeneratoreUrl::creaUrlContenuto($contenuto, $impostazioniAspetto["ottimizzazioneUrl"], $impostazioniAspetto["urlSito"]) : $impostazioniAspetto["urlSito"];            $datiLogo = array("@type"=>"ImageObject","url"=>$impostazioniAspetto["urlSito"]."/".$configurazioneAspetto["logo"]);
            if($contenuto["tipo"]=="articolo") {
                $datiStrutturati = GeneratoreDatiStrutturati::generaDatiArticolo($contenuto,$link,$impostazioniAspetto,$datiLogo);
            }
            else {
                $datiStrutturati = GeneratoreDatiStrutturati::generaDatiPagina($contenuto,$link,$impostazioniAspetto,$datiLogo);
            }
            echo"<!-- Dati strutturati del contenuto -->
		<script type=\"application/ld+json\">";
            echo json_encode($datiStrutturati);
            echo"</script>";
        }
        
        static function generaDatiArticolo($contenuto,$url,$impostazioniAspetto,$datiLogo) {
            $datiStrutturati = array();
            $datiStrutturati["@context"] = "http://schema.org";
            $datiStrutturati["@type"]    = "NewsArticle";
            $datiStrutturati["url"] = $url;
            $datiStrutturati["publisher"]        = array("@type"=>"Organization","name"=>$impostazioniAspetto["titoloSito"],"logo"=>$datiLogo);
            $datiStrutturati["headline"]         = $contenuto["titolo"];
            $datiStrutturati["mainEntityOfPage"] = $url;
            $datiStrutturati["articleBody"]      = $contenuto["descrizione"];
            $datiStrutturati["image"]            = array($impostazioniAspetto["urlSito"]."/".$contenuto["foto"]);
            $datiStrutturati["author"]           = array("type"=>"Person","name"=>$contenuto["autore"]);
            $datiStrutturati["datePublished"]    = date("Y-m-d",strtotime($contenuto["dataPubblicazione"]))."T".date("H:i:s",strtotime($contenuto["dataPubblicazione"]))."+00:00";
            $datiStrutturati["dateModified"]     = date("Y-m-d",strtotime($contenuto["dataUltimaModifica"]))."T".date("H:i:s",strtotime($contenuto["dataUltimaModifica"]))."+00:00";
            return $datiStrutturati;
        }
        
        static function generaDatiPagina($contenuto,$url,$impostazioniAspetto,$datiLogo) {
            $datiStrutturati = array();
            $datiStrutturati["@context"] = "http://schema.org";
            $datiStrutturati["@type"]    = "WebPage";
            $datiStrutturati["url"] = $url;
            $datiStrutturati["publisher"]        = array("@type"=>"Organization","name"=>$impostazioniAspetto["titoloSito"],"logo"=>$datiLogo);
            $datiStrutturati["headline"]         = $contenuto["titolo"];
            $datiStrutturati["mainEntityOfPage"] = $url;
            $datiStrutturati["articleBody"]      = $contenuto["descrizione"];
            $datiStrutturati["image"]            = array($impostazioniAspetto["urlSito"]."/".$contenuto["foto"]);
            return $datiStrutturati;
        }
    }